using UnityEngine;
using TMPro;

public class Timer : MonoBehaviour
{
    public TextMeshProUGUI timeRemainingText;
    public TextMeshProUGUI gameOverText;
    public TextMeshProUGUI objective;
    public GameObject image;
    public GameManager manager;

    void Update()
    {
        if (!manager.isGameOver)
        {
            
            timeRemainingText.text = manager.totalTimeElapsed.ToString();
            gameOverText.enabled = false;
        }
        if (manager.isGameOver) { 
            image.SetActive(false);
            timeRemainingText.enabled = false;
            objective.enabled = false;
            gameOverText.enabled = true;
            gameOverText.text = ("Congratulations on exiting the maze! \nYour Time is:" + manager.totalTimeElapsed.ToString());
            Time.timeScale = 0;
        }
    }
}
